# Quick Reference - Analog Mainnet

## 🚀 Deploy Everything (One Command)

```powershell
cd analog-mainnet
python deploy.py
```

---

## 📍 Endpoints After Deployment

| Service | URL |
|---------|-----|
| **Dashboard** | http://localhost:8080 |
| **Consensus API** | http://localhost:9999/api/status |
| **Metrics** | http://localhost:9999/metrics |
| **Peers** | http://localhost:9999/api/netcat |
| **Web API** | http://localhost:8080/api/consensus/status |

---

## 📝 Contract Commands

```powershell
# Deploy contract
python contracts\analog_contract_cli.py deploy <file> --name "Name"

# List contracts
python contracts\analog_contract_cli.py list

# Check status
python contracts\analog_contract_cli.py status

# Show POA comparison
python contracts\analog_contract_cli.py compare
```

---

## 🔍 Check Status

```powershell
# Consensus status (JSON)
curl http://localhost:9999/api/status

# Web status
curl http://localhost:8080/api/consensus/status

# System info
curl http://localhost:8080/api/system/info
```

---

## 📊 Key Metrics

- **Evolution Rate**: 32,768 Hz
- **Consensus Threshold**: CV < 0.1%
- **Validators**: 0 (deterministic)
- **Finality**: Instant (when locked)
- **Speed**: 1,000,000× faster than POA

---

## 🛑 Stop Services

Press `Ctrl+C` in the deploy.py terminal

---

## 📁 Important Files

| File | Purpose |
|------|---------|
| `deploy.py` | One-command deployment |
| `README.md` | Full documentation |
| `docs/MIGRATION_GUIDE.md` | POA migration guide |
| `web/analog_api_server.py` | Flask API server |
| `web/dashboard.html` | Real-time dashboard |
| `contracts/analog_contract_cli.py` | Contract deployment CLI |
| `orchestration/orchestrate.py` | Configuration generator |

---

## ⚡ Quick Test

```powershell
# 1. Deploy
python deploy.py

# 2. In new terminal, check status
curl http://localhost:9999/api/status

# 3. Open dashboard
start http://localhost:8080

# 4. Deploy example contract
python contracts\analog_contract_cli.py deploy contracts\example_contract.ac
```

---

## 🔧 Troubleshooting

### Engine not compiling?
```powershell
cd src
gcc -o hdgl_bridge hdgl_bridge_v40.c hdgl_http_api.c hdgl_netcat.c -lm -lpthread -lwinmm -lws2_32
```

### Web services not starting?
```powershell
pip install flask flask-cors requests
cd web
python analog_api_server.py
```

### Check logs
```powershell
type logs\consensus_engine.log
type logs\web_services.log
```

---

**That's it! You're running Analog Mainnet.** 🚀
