/*
 * HDGL Analog NetCat Header - C Module
 * Dₙ(r) Consensus-Based Network Communication Tool
 */

#ifndef HDGL_NETCAT_H
#define HDGL_NETCAT_H

#include <pthread.h>

// Function declarations for NetCat integration
int init_hdgl_netcat(void);
int start_netcat_server(int port);
void stop_netcat_server(void);
int netcat_connect_client(const char* host, int port);
int netcat_send_message(int socket_fd, const char* message);
void get_netcat_status(char* json, int max_len);
void cleanup_hdgl_netcat(void);

// Analog encryption functions
void evolve_dimensions(void);
void generate_analog_key(void);
int analog_encrypt(const char* message, char* encrypted, int max_len);
int analog_decrypt(const char* encrypted_hex, char* message, int max_len);

// Headless mode functions
int configure_headless_mode(int enabled, const char* target_hosts[], int target_ports[], int target_count);
int start_headless_mode(void);
void stop_headless_mode(void);

#endif // HDGL_NETCAT_H
