# Simple convergence monitor
Write-Host "`nMonitoring Hybrid Feedback Convergence..." -ForegroundColor Cyan
Write-Host "Press Ctrl+C to stop`n"

$samples = @()

for ($i = 0; $i -lt 60; $i++) {
    Start-Sleep -Seconds 1

    try {
        $response = Invoke-WebRequest -Uri "http://localhost:9999/api/status" -UseBasicParsing -ErrorAction Stop
        $data = $response.Content | ConvertFrom-Json

        $variance = [double]$data.phase_variance
        $locked = [int]$data.locked
        $evo = [long]$data.evolution_count

        $samples += $variance

        $status = if ($locked -eq 1) { "LOCKED" } else { "Unlocked" }
        $time = "t=$($i.ToString('D2'))s"

        Write-Host "$time | evo=$($evo.ToString('D9')) | variance=$($variance.ToString('F6')) | $status"

        if ($locked -eq 1) {
            Write-Host "`nCONSENSUS ACHIEVED!" -ForegroundColor Green
            break
        }
    }
    catch {
        Write-Host "t=$($i)s | Unable to connect" -ForegroundColor DarkYellow
    }
}

if ($samples.Count -ge 20) {
    Write-Host "`nAnalysis:" -ForegroundColor Cyan
    $first10 = ($samples[0..9] | Measure-Object -Average).Average
    $last10 = ($samples[-10..-1] | Measure-Object -Average).Average
    $change = (($last10 - $first10) / $first10) * 100

    Write-Host "First 10s avg: $($first10.ToString('F4'))"
    Write-Host "Last 10s avg:  $($last10.ToString('F4'))"
    Write-Host "Change: $($change.ToString('F2'))%"

    if ($change -lt -5) {
        Write-Host "Result: CONVERGING (hybrid feedback working)" -ForegroundColor Green
    } else {
        Write-Host "Result: OSCILLATING (feedback may be too weak)" -ForegroundColor Yellow
    }
}
