# Real-Time Attractor Geometry Visualization

Live visualization tools for monitoring the V4.2 Hybrid strange attractor dynamics.

## Available Visualizations

### 1. Multi-Panel Dashboard (`live_dim_plot.py`)
**Shows:**
- Dimensional amplitudes over time (log scale)
- Dₙ(r) geometric resonance values
- Real-time coupling matrix heatmap
- 2D phase space projection (D1-D2)
- Status panel with dimension health

**Run:**
```bash
cd scripts
python live_dim_plot.py
```

### 2. 3D Attractor View (`live_3d_attractor.py`)
**Shows:**
- 3D strange attractor trajectory (D1-D2-D3 projection)
- Auto-rotating view
- Dimensional collapse timeline
- Manifold structure (current amplitudes)

**Run:**
```bash
cd scripts
python live_3d_attractor.py
```

## Requirements

- Python 3.8+
- matplotlib
- numpy

**Install (if needed):**
```bash
pip install matplotlib numpy
```

## Features

### Real-Time Monitoring
- Reads `logs/peer1.log` continuously
- Updates every 0.5-1 second
- Keeps last 500-2000 data points

### Dimensional Decoupling Detection
- Identifies active/weak/dead dimensions
- Shows coupling strength between dimensions
- Tracks collapse from 8D → 6D → 5D → ...

### Beautiful Mathematics
- Exponential coupling kernel: `exp(-|ΔDₙ|/50)`
- Phase space compression visible in real-time
- Attractor geometry evolution

## Controls

- **Pan:** Click and drag
- **Zoom:** Scroll wheel
- **Rotate (3D):** Click and drag
- **Close:** Ctrl+C or close window

## What You're Seeing

### Amplitude Plot (Top)
Shows the complex amplitude `|z_i|` for each dimension. When a dimension decouples, its amplitude decays exponentially to zero due to damping with no coupling energy input.

### Dₙ Plot (Middle)
Shows the geometric resonance parameter `Dₙ(r) = sqrt(φ·Fₙ·2ⁿ·Pₙ·Ω)·rᵏ`. When Dₙ grows large, dimensions decouple via the exponential kernel.

### Coupling Matrix (Bottom Left)
Heatmap of `exp(-|Dₙᵢ - Dₙⱼ|/50)`. White = strong coupling, Black = decoupled. Watch D8, D7, D6 progressively isolate.

### 3D Attractor (3D View)
The actual strange attractor trajectory in D1-D2-D3 space. Shows the manifold structure and how it evolves. Recent positions are brighter (cyan/yellow), older positions fade to purple.

### Status Panel
Real-time dimension health:
- ✓ ACTIVE: Amplitude > 10⁻⁵
- ⚠ WEAK: Amplitude 10⁻¹⁰ to 10⁻⁵
- ✗ DEAD: Amplitude < 10⁻¹⁰

## Performance

- Minimal overhead (~1% CPU per visualization)
- Reads only new log lines (tail behavior)
- Safe to run alongside the 5-peer network

## Example Output

After ~458M evolutions, you should see:
- D8: DEAD (Dₙ = 25,410)
- D7: WEAK (Dₙ = 11,655, amplitude decaying)
- D6: ACTIVE but coupling weakening (Dₙ = 4,996)
- D1-D5: ACTIVE and strongly coupled

The 3D attractor will show a compressed manifold with most energy in D1-D3.

## Troubleshooting

**"No module named matplotlib"**
```bash
pip install matplotlib numpy
```

**"FileNotFoundError: logs/peer1.log"**
Make sure the 5-peer network is running:
```bash
cd ..
for ($i=1; $i -le 5; $i++) {
    Start-Process wsl -ArgumentList "bash","-c",
    "cd '...' ; ./analog_codec_v42_hybrid 2>&1 | tee logs/peer$i.log"
}
```

**Blank/frozen display**
- Check that peer1.log is growing: `ls -lh ../logs/peer1.log`
- Verify log format matches expected pattern
- Try closing and restarting the visualization

## Advanced: Recording

To save the visualization as a video:
```python
# Add to the script:
from matplotlib.animation import FFMpegWriter
writer = FFMpegWriter(fps=30)
anim.save('attractor.mp4', writer=writer)
```

Requires `ffmpeg` installed.
