# 5-Peer Local Testnet Quick Start

## Overview

Launch 5 framework-native peers locally to test the V4.2-Hybrid consensus network.

- **4 Validators** (Peers 1-4): Active consensus participants
- **1 Archive Node** (Peer 5): Full history preservation
- **Quorum**: 67% (3/4 validators needed)
- **Byzantine Tolerance**: 1 fault tolerated
- **Target Performance**: 476,440 Hz per peer

## Network Topology

```
┌─────────────────────────────────────────────────┐
│  Peer 1 (Primary/Bootstrap)                    │
│  Port: 9095 │ API: 8091 │ Metrics: 9096       │
│  Type: Validator                                │
└────────────┬────────────────────────────────────┘
             │
    ┌────────┴──────────┬────────────┬────────────┐
    │                   │            │            │
┌───▼────┐          ┌───▼────┐   ┌───▼────┐   ┌───▼────┐
│ Peer 2 │          │ Peer 3 │   │ Peer 4 │   │ Peer 5 │
│ 9097   │          │ 9099   │   │ 9101   │   │ 9103   │
│Validator│         │Validator│  │Validator│  │Archive │
└────────┘          └────────┘   └────────┘   └────────┘
```

## Quick Start

### Option 1: PowerShell (Windows)

```powershell
cd "C:\Users\Owner\Documents\Josef's Code 2025\K equals epsilon\analog-mainnet\framework_native"

# Launch all 5 peers
.\launch_5peers.ps1

# Check status
wsl bash -c "./check_peers.sh"

# Stop all peers
wsl bash -c "./stop_peers.sh"
```

### Option 2: Bash (WSL/Linux)

```bash
cd "/mnt/c/Users/Owner/Documents/Josef's Code 2025/K equals epsilon/analog-mainnet/framework_native"

# Make scripts executable (first time only)
chmod +x launch_5peers.sh check_peers.sh stop_peers.sh

# Launch all 5 peers
./launch_5peers.sh

# Check status
./check_peers.sh

# Stop all peers
./stop_peers.sh
```

## Port Configuration

| Peer | Type      | Listen | API  | Metrics | Data Dir      |
|------|-----------|--------|------|---------|---------------|
| 1    | Validator | 9095   | 8091 | 9096    | ./data/peer1  |
| 2    | Validator | 9097   | 8092 | 9098    | ./data/peer2  |
| 3    | Validator | 9099   | 8093 | 9100    | ./data/peer3  |
| 4    | Validator | 9101   | 8094 | 9102    | ./data/peer4  |
| 5    | Archive   | 9103   | 8095 | 9104    | ./data/peer5  |

## Monitoring

### View Logs

**Individual peer:**
```bash
tail -f logs/peer1.log
```

**All peers:**
```bash
tail -f logs/peer*.log
```

**Search for consensus activity:**
```bash
grep -i "checkpoint\|consensus\|PHASE" logs/peer*.log
```

### Check Metrics

```bash
# Peer 1 metrics
curl http://localhost:9096/metrics

# Peer 2 metrics
curl http://localhost:9098/metrics
```

### Check Consensus Health

```bash
./check_peers.sh
```

Expected output:
```
✓ Peer 1 │ PID: 12345 │ Port: 9095 │ API: 8091 │ Metrics: 9096
✓ Peer 2 │ PID: 12346 │ Port: 9097 │ API: 8092 │ Metrics: 9098
✓ Peer 3 │ PID: 12347 │ Port: 9099 │ API: 8093 │ Metrics: 9100
✓ Peer 4 │ PID: 12348 │ Port: 9101 │ API: 8094 │ Metrics: 9102
✓ Peer 5 │ PID: 12349 │ Port: 9103 │ API: 8095 │ Metrics: 9104

Running Peers:  5 / 5
Consensus:      ✓ QUORUM AVAILABLE (need 3/4 validators)
```

## Consensus Verification

### Expected Behavior

1. **Bootstrap Phase** (First 10 seconds):
   - Peer 1 starts first (primary/bootstrap)
   - Peers 2-5 connect to Peer 1
   - All peers initialize with same genesis seed

2. **Synchronization** (10-30 seconds):
   - Peers exchange initial state
   - GMP validation begins
   - Phase transitions: Emergency → Pluck → Sustain

3. **Consensus** (After 30 seconds):
   - All validators compute evolutions independently
   - Checkpoint hashes broadcast every 1000 evolutions (~2.1 seconds)
   - Quorum verification (3/4 validators must agree)

### Verify Consensus

Check that all peers reach the same checkpoint:

```bash
# Extract checkpoint hashes from logs
grep "checkpoint" logs/peer1.log | tail -5
grep "checkpoint" logs/peer2.log | tail -5
grep "checkpoint" logs/peer3.log | tail -5
grep "checkpoint" logs/peer4.log | tail -5
```

**Expected:** All peers show identical SHA-256 hashes at same evolution count.

## Fault Tolerance Testing

### Test 1: Single Peer Failure

```bash
# Kill one validator (Peer 2)
kill $(pgrep -f "analog_codec_v42_hybrid.*peer2")

# Check consensus still works
./check_peers.sh
# Expected: "✓ QUORUM AVAILABLE" (3/4 validators = 75% > 67%)
```

### Test 2: Two Peer Failure (At Byzantine Limit)

```bash
# Kill two validators (Peers 2 and 3)
kill $(pgrep -f "analog_codec_v42_hybrid.*peer2")
kill $(pgrep -f "analog_codec_v42_hybrid.*peer3")

# Check consensus
./check_peers.sh
# Expected: "⚠ BELOW QUORUM" (2/4 validators = 50% < 67%)
```

### Test 3: Archive Node Failure

```bash
# Kill archive node (Peer 5)
kill $(pgrep -f "analog_codec_v42_hybrid.*peer5")

# Check consensus
./check_peers.sh
# Expected: "✓ QUORUM AVAILABLE" (4/4 validators still running)
```

## Troubleshooting

### Peers Won't Start

**Check if ports are in use:**
```bash
netstat -tuln | grep -E "9095|9097|9099|9101|9103"
```

**Kill any conflicting processes:**
```bash
./stop_peers.sh
pkill -f analog_codec_v42_hybrid
```

### Consensus Not Forming

**Check peer logs for errors:**
```bash
grep -i "error\|fail\|fatal" logs/peer*.log
```

**Verify genesis seed matches:**
```bash
grep "genesis" logs/peer*.log
# All should show: 0x6b3a8e7f...3a9b6e
```

### Slow Performance

**Check CPU usage:**
```bash
top -p $(pgrep -f analog_codec_v42_hybrid | tr '\n' ',')
```

**Expected:** Each peer ~10-15% CPU (total ~50-75%)

**If 100% CPU:** GMP bottleneck detected. Check if hybrid mode is active:
```bash
grep "hybrid" logs/peer1.log
```

## Performance Benchmarks

### Expected Metrics (Per Peer)

- **Evolution Rate:** 450,000 - 480,000 Hz
- **Checkpoint Interval:** ~2.1 seconds (1000 evolutions)
- **GMP Validation Time:** ~5-10 ms per checkpoint
- **Consensus Latency:** <5 ms (localhost)
- **Memory Usage:** ~50-100 MB per peer

### Network Performance

- **Total Network Hz:** 476,440 Hz × 5 peers = **2,382,200 Hz**
- **Bandwidth:** ~4.5 kbps per peer (checkpoints only)
- **Consensus Agreement:** <10 ms (all local)

## Configuration

### Edit Network Parameters

Edit `config/local_5peers.json`:

```json
{
  "consensus": {
    "min_validators": 3,        // Minimum validators for quorum
    "quorum_percentage": 67,    // Percentage needed for consensus
    "checkpoint_interval": 1000 // Evolutions between checkpoints
  },
  "evolution": {
    "target_hz": 476440,        // Target evolution rate
    "sync_interval": 1000       // GMP validation interval
  }
}
```

After editing, restart peers:
```bash
./stop_peers.sh
./launch_5peers.sh
```

## Adding More Peers

To scale to 10+ peers:

1. **Edit `launch_5peers.sh`:**
   - Add more peer launch commands
   - Use ports: 9105, 9107, 9109, etc.
   - API ports: 8096, 8097, 8098, etc.

2. **Update quorum calculation:**
   - 10 peers: Need 7/9 validators (78% > 67%)
   - Byzantine tolerance: ⌊(9-1)/3⌋ = 2 faults

3. **Monitor system resources:**
   - Each peer: ~15% CPU, ~100 MB RAM
   - 10 peers: ~150% CPU (2 cores), ~1 GB RAM

## Integration with Global WAN

Once local testnet is stable, connect to global WAN:

1. **Update peer 1 config to global:**
   ```bash
   --config config/wan_peers_global.json
   ```

2. **Configure firewall for external connections:**
   ```bash
   # Allow incoming on port 9095
   sudo ufw allow 9095/tcp
   ```

3. **Start with WAN bootstrap peers:**
   ```bash
   --bootstrap london.analog-mainnet.net:9095,tokyo.analog-mainnet.net:9095
   ```

## Files Created

- `config/local_5peers.json` - Network configuration
- `launch_5peers.sh` - Launch script (bash)
- `launch_5peers.ps1` - Launch script (PowerShell)
- `check_peers.sh` - Status monitoring
- `stop_peers.sh` - Graceful shutdown

## Next Steps

1. ✅ Launch 5-peer local testnet
2. ⏭️ Verify consensus formation (<1 minute)
3. ⏭️ Test fault tolerance (kill 1 peer)
4. ⏭️ Monitor performance (should hit 476,440 Hz)
5. ⏭️ Scale to 10+ peers
6. ⏭️ Connect to global WAN network

---

**Ready to launch?**

```bash
./launch_5peers.sh
```

🚀 **Let's achieve consensus at 476,440 Hz!**
