# Quick 5-Peer Launch for Testing
# Runs 5 instances of analog_codec_v42_hybrid in background

$ErrorActionPreference = "Stop"

Write-Host "`n╔═══════════════════════════════════════════════════╗" -ForegroundColor Cyan
Write-Host "║   Launching 5 Peers for Testing                 ║" -ForegroundColor Cyan
Write-Host "╚═══════════════════════════════════════════════════╝`n" -ForegroundColor Cyan

$WSL_CMD = "cd '/mnt/c/Users/Owner/Documents/Josef''s Code 2025/K equals epsilon/analog-mainnet/framework_native'"

# Build
Write-Host "Building..." -ForegroundColor Blue
wsl bash -c "$WSL_CMD && make v42-hybrid"
Write-Host "✓ Build complete`n" -ForegroundColor Green

# Create dirs
wsl bash -c "$WSL_CMD && mkdir -p logs data"

# Launch 5 peers
Write-Host "Launching 5 peers...`n" -ForegroundColor Yellow

for ($i = 1; $i -le 5; $i++) {
    Write-Host "  ▶ Starting Peer $i" -ForegroundColor Green
    Start-Process wsl -ArgumentList "bash","-c","cd '/mnt/c/Users/Owner/Documents/Josef''s Code 2025/K equals epsilon/analog-mainnet/framework_native' && ./analog_codec_v42_hybrid > logs/peer$i.log 2>&1" -WindowStyle Minimized
    Start-Sleep -Milliseconds 500
}

Write-Host "`n✓ All 5 peers launched!`n" -ForegroundColor Green

Start-Sleep -Seconds 3

$count = wsl bash -c "ps aux | grep analog_codec_v42_hybrid | grep -v grep | wc -l"
Write-Host "═══════════════════════════════════════════════════" -ForegroundColor Cyan
Write-Host "Running peers: $count / 5" -ForegroundColor $(if ([int]$count -ge 5) { "Green" } else { "Yellow" })
Write-Host "═══════════════════════════════════════════════════`n" -ForegroundColor Cyan

Write-Host "Monitor logs:" -ForegroundColor Yellow
Write-Host "  wsl bash -c ""cd '/mnt/c/Users/Owner/Documents/Josef''s Code 2025/K equals epsilon/analog-mainnet/framework_native' && tail -f logs/peer1.log""`n"

Write-Host "Stop all peers:" -ForegroundColor Yellow
Write-Host "  wsl bash -c ""pkill -f analog_codec_v42_hybrid""`n"
