# Launch Real-Time Attractor Visualization
# Choose your view

Write-Host "Analog Mainnet V4.2 - Live Geometry Viewer" -ForegroundColor Cyan
Write-Host "==========================================" -ForegroundColor Cyan
Write-Host ""
Write-Host "Choose visualization:" -ForegroundColor Yellow
Write-Host "  1) Multi-Panel Dashboard (amplitudes, Dn, coupling matrix, phase space)"
Write-Host "  2) 3D Attractor View (rotating 3D trajectory)"
Write-Host "  3) Both (two windows)"
Write-Host ""

$choice = Read-Host "Enter choice (1-3)"

$scriptPath = "scripts"

switch ($choice) {
    "1" {
        Write-Host "Launching multi-panel dashboard..." -ForegroundColor Green
        python "$scriptPath\live_dim_plot.py"
    }
    "2" {
        Write-Host "Launching 3D attractor view..." -ForegroundColor Green
        python "$scriptPath\live_3d_attractor.py"
    }
    "3" {
        Write-Host "Launching both visualizations..." -ForegroundColor Green
        Start-Process python -ArgumentList "$scriptPath\live_dim_plot.py" -NoNewWindow
        Start-Sleep -Seconds 1
        python "$scriptPath\live_3d_attractor.py"
    }
    default {
        Write-Host "Invalid choice. Exiting." -ForegroundColor Red
        exit 1
    }
}
