# Wu-Wei Compression Test
Write-Host 'Building Wu-Wei compression test...'

if (-not (Get-Command gcc -ErrorAction SilentlyContinue)) {
    Write-Host 'GCC not found. Install MinGW or use WSL.'
    Write-Host 'WSL: wsl --install'
    Write-Host 'Then: sudo apt-get install gcc zlib1g-dev'
    exit 1
}

Write-Host 'Compiling...'
gcc -o test_wu_wei.exe src\test_wu_wei.c src\wu_wei_compress.c -lz -lm -O2

if (0 -eq 0) {
    Write-Host 'Success! Running tests...'
    .\test_wu_wei.exe
} else {
    Write-Host 'Compilation failed. Missing zlib?'
    Write-Host 'Try WSL: wsl sudo apt-get install zlib1g-dev'
}