#!/bin/bash
# Wu-Wei Compression Benchmark Script
# Compares Wu-Wei against traditional compression on 10MB files

set -e

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PROJECT_DIR="$(dirname "$SCRIPT_DIR")"
cd "$PROJECT_DIR"

echo "╔════════════════════════════════════════════════════════════════════╗"
echo "║       WU-WEI COMPRESSION BENCHMARK BUILD & RUN                     ║"
echo "╚════════════════════════════════════════════════════════════════════╝"
echo ""

# Check for required files
if [ ! -f "src/test_wu_wei_benchmark.c" ]; then
    echo "❌ Error: src/test_wu_wei_benchmark.c not found"
    exit 1
fi

if [ ! -f "src/wu_wei_compress.c" ]; then
    echo "❌ Error: src/wu_wei_compress.c not found"
    exit 1
fi

echo "✓ Source files found"

# Check for GCC
if ! command -v gcc &> /dev/null; then
    echo "❌ Error: GCC not found. Please install build-essential:"
    echo "   sudo apt-get install build-essential zlib1g-dev"
    exit 1
fi

echo "✓ GCC found: $(gcc --version | head -n1)"
echo ""

# Compile
echo "Compiling Wu-Wei benchmark (10MB test, may take a moment)..."
echo "Command: gcc -o test_wu_wei_benchmark src/test_wu_wei_benchmark.c src/wu_wei_compress.c -lz -lm -O2"
echo ""

gcc -o test_wu_wei_benchmark \
    src/test_wu_wei_benchmark.c \
    src/wu_wei_compress.c \
    -lz -lm -O2

if [ $? -eq 0 ]; then
    SIZE=$(ls -lh test_wu_wei_benchmark | awk '{print $5}')
    echo "✅ Compilation successful!"
    echo "   Binary size: $SIZE"
    echo ""
else
    echo "❌ Compilation failed"
    exit 1
fi

# Run benchmark
echo "Running benchmark (this may take 30-60 seconds)..."
echo "═══════════════════════════════════════════════════════════════════"
echo ""

./test_wu_wei_benchmark

EXIT_CODE=$?

echo ""
echo "═══════════════════════════════════════════════════════════════════"

if [ $EXIT_CODE -eq 0 ]; then
    echo "✅ Benchmark completed successfully!"
else
    echo "❌ Benchmark failed with exit code $EXIT_CODE"
fi

exit $EXIT_CODE
