# Simple 5-Peer Launch (Manual Method)
# Since analog_codec_v42_hybrid doesn't support CLI args yet,
# we'll just run 5 instances in separate terminals

Write-Host ""
Write-Host "╔═══════════════════════════════════════════════════╗" -ForegroundColor Cyan
Write-Host "║   5-Peer Testnet - Manual Launch Guide          ║" -ForegroundColor Cyan
Write-Host "╚═══════════════════════════════════════════════════╝" -ForegroundColor Cyan
Write-Host ""

Write-Host "Since the codec doesn't have CLI arguments yet," -ForegroundColor Yellow
Write-Host "we'll launch 5 instances manually for testing." -ForegroundColor Yellow
Write-Host ""

$WSL_PATH = "/mnt/c/Users/Owner/Documents/Josef's Code 2025/K equals epsilon/analog-mainnet/framework_native"

# Build first
Write-Host "Building analog_codec_v42_hybrid..." -ForegroundColor Blue
wsl bash -c "cd '$WSL_PATH' && make v42-hybrid"
Write-Host "✓ Build complete" -ForegroundColor Green
Write-Host ""

# Create directories
Write-Host "Creating peer directories..." -ForegroundColor Blue
wsl bash -c "cd '$WSL_PATH' && mkdir -p data/{peer1,peer2,peer3,peer4,peer5} logs"
Write-Host "✓ Directories created" -ForegroundColor Green
Write-Host ""

Write-Host "═══════════════════════════════════════════════════" -ForegroundColor Cyan
Write-Host "  Launch Instructions" -ForegroundColor Cyan
Write-Host "═══════════════════════════════════════════════════" -ForegroundColor Cyan
Write-Host ""

Write-Host "Open 5 separate PowerShell/WSL terminals and run:" -ForegroundColor Yellow
Write-Host ""

Write-Host "Terminal 1 (Peer 1):" -ForegroundColor Green
Write-Host "  wsl bash -c `"cd '$WSL_PATH' && ./analog_codec_v42_hybrid | tee logs/peer1.log`""
Write-Host ""

Write-Host "Terminal 2 (Peer 2):" -ForegroundColor Green
Write-Host "  wsl bash -c `"cd '$WSL_PATH' && ./analog_codec_v42_hybrid | tee logs/peer2.log`""
Write-Host ""

Write-Host "Terminal 3 (Peer 3):" -ForegroundColor Green
Write-Host "  wsl bash -c `"cd '$WSL_PATH' && ./analog_codec_v42_hybrid | tee logs/peer3.log`""
Write-Host ""

Write-Host "Terminal 4 (Peer 4):" -ForegroundColor Green
Write-Host "  wsl bash -c `"cd '$WSL_PATH' && ./analog_codec_v42_hybrid | tee logs/peer4.log`""
Write-Host ""

Write-Host "Terminal 5 (Peer 5):" -ForegroundColor Green
Write-Host "  wsl bash -c `"cd '$WSL_PATH' && ./analog_codec_v42_hybrid | tee logs/peer5.log`""
Write-Host ""

Write-Host "═══════════════════════════════════════════════════" -ForegroundColor Cyan
Write-Host "  OR: Use background processes" -ForegroundColor Cyan
Write-Host "═══════════════════════════════════════════════════" -ForegroundColor Cyan
Write-Host ""

$choice = Read-Host "Launch 5 peers in background? (y/n)"

if ($choice -eq "y") {
    Write-Host ""
    Write-Host "Launching 5 peers in background..." -ForegroundColor Yellow
    Write-Host ""

    Write-Host "▶ Starting Peer 1..." -ForegroundColor Green
    Start-Process wsl -ArgumentList "bash", "-c", "cd '$WSL_PATH' && ./analog_codec_v42_hybrid > logs/peer1.log 2>&1" -WindowStyle Minimized
    Start-Sleep -Seconds 1

    Write-Host "▶ Starting Peer 2..." -ForegroundColor Green
    Start-Process wsl -ArgumentList "bash", "-c", "cd '$WSL_PATH' && ./analog_codec_v42_hybrid > logs/peer2.log 2>&1" -WindowStyle Minimized
    Start-Sleep -Seconds 1

    Write-Host "▶ Starting Peer 3..." -ForegroundColor Green
    Start-Process wsl -ArgumentList "bash", "-c", "cd '$WSL_PATH' && ./analog_codec_v42_hybrid > logs/peer3.log 2>&1" -WindowStyle Minimized
    Start-Sleep -Seconds 1

    Write-Host "▶ Starting Peer 4..." -ForegroundColor Green
    Start-Process wsl -ArgumentList "bash", "-c", "cd '$WSL_PATH' && ./analog_codec_v42_hybrid > logs/peer4.log 2>&1" -WindowStyle Minimized
    Start-Sleep -Seconds 1

    Write-Host "▶ Starting Peer 5..." -ForegroundColor Green
    Start-Process wsl -ArgumentList "bash", "-c", "cd '$WSL_PATH' && ./analog_codec_v42_hybrid > logs/peer5.log 2>&1" -WindowStyle Minimized

    Write-Host ""
    Write-Host "✓ All 5 peers launched in background!" -ForegroundColor Green
    Write-Host ""
    Write-Host "═══════════════════════════════════════════════════" -ForegroundColor Cyan
    Write-Host "  Monitoring" -ForegroundColor Cyan
    Write-Host "═══════════════════════════════════════════════════" -ForegroundColor Cyan
    Write-Host ""
    Write-Host "  View Peer 1 log:" -ForegroundColor Yellow
    Write-Host "    wsl bash -c `"cd '$WSL_PATH' && tail -f logs/peer1.log`""
    Write-Host ""
    Write-Host "  View all peers:" -ForegroundColor Yellow
    Write-Host "    wsl bash -c `"cd '$WSL_PATH' && tail -f logs/peer*.log`""
    Write-Host ""
    Write-Host "  Stop all peers:" -ForegroundColor Yellow
    Write-Host "    wsl bash -c `"pkill -f analog_codec_v42_hybrid`""
    Write-Host ""

    Write-Host "Waiting for initialization (5 seconds)..." -ForegroundColor Yellow
    Start-Sleep -Seconds 5

    Write-Host "Checking peer processes..." -ForegroundColor Blue
    $peerCount = wsl bash -c "ps aux | grep analog_codec_v42_hybrid | grep -v grep | wc -l"
    Write-Host "Running peers: $peerCount / 5" -ForegroundColor $(if ($peerCount -ge 5) { "Green" } else { "Yellow" })
    Write-Host ""
}

Write-Host "═══════════════════════════════════════════════════" -ForegroundColor Cyan
Write-Host "  Ready!" -ForegroundColor Green
Write-Host "═══════════════════════════════════════════════════" -ForegroundColor Cyan
Write-Host ""
