# Launch 5 Local Peers for Analog Mainnet V4.2-Hybrid (Windows/WSL)
# Framework-native containers (not Docker!)

$ErrorActionPreference = "Stop"

$CONFIG_FILE = "config/local_5peers.json"
$WSL_PATH = "/mnt/c/Users/Owner/Documents/Josef's Code 2025/K equals epsilon/analog-mainnet/framework_native"

Write-Host ""
Write-Host "╔═══════════════════════════════════════════════════╗" -ForegroundColor Cyan
Write-Host "║   Analog Mainnet V4.2-Hybrid: 5-Peer Testnet    ║" -ForegroundColor Cyan
Write-Host "╚═══════════════════════════════════════════════════╝" -ForegroundColor Cyan
Write-Host ""

# Check if WSL is available
try {
    wsl --version | Out-Null
} catch {
    Write-Host "✗ WSL not found. Please install WSL." -ForegroundColor Red
    exit 1
}

Write-Host "Creating peer directories..." -ForegroundColor Blue
wsl bash -c "cd '$WSL_PATH' && mkdir -p data/{peer1,peer2,peer3,peer4,peer5} logs"
Write-Host "✓ Directories created" -ForegroundColor Green
Write-Host ""

# Kill existing peers
Write-Host "Cleaning up existing peer processes..." -ForegroundColor Yellow
wsl bash -c "pkill -f 'analog_codec_v42_hybrid.*peer' || true"
Start-Sleep -Seconds 1
Write-Host "✓ Cleanup complete" -ForegroundColor Green
Write-Host ""

# Build if needed
Write-Host "Checking binary..." -ForegroundColor Blue
$binaryExists = wsl bash -c "cd '$WSL_PATH' && test -f analog_codec_v42_hybrid && echo 'yes' || echo 'no'"
if ($binaryExists -eq "no") {
    Write-Host "Building analog_codec_v42_hybrid..." -ForegroundColor Yellow
    wsl bash -c "cd '$WSL_PATH' && make v42-hybrid"
    Write-Host "✓ Build complete" -ForegroundColor Green
}
Write-Host ""

$genesis = "0x6b3a8e7f2d9c4a1b5e8f3d7c2a9b6e4f1c8d5a7b3e9f2c6a4d8b1e7f5c3a9b6e"

# Launch Peer 1 (Primary)
Write-Host "▶ Launching Peer 1 (Primary)..." -ForegroundColor Green
Write-Host "   Port: 9095 │ API: 8091 │ Metrics: 9096"
wsl bash -c "cd '$WSL_PATH' && nohup ./analog_codec_v42_hybrid --node-id 1 --name 'Local-Peer-1' --port 9095 --api-port 8091 --metrics-port 9096 --data-dir ./data/peer1 --mode validator --genesis $genesis > logs/peer1.log 2>&1 &"
Start-Sleep -Milliseconds 2000

# Launch Peer 2
Write-Host "▶ Launching Peer 2..." -ForegroundColor Green
Write-Host "   Port: 9097 │ API: 8092 │ Metrics: 9098 │ Bootstrap: localhost:9095"
wsl bash -c "cd '$WSL_PATH' && nohup ./analog_codec_v42_hybrid --node-id 2 --name 'Local-Peer-2' --port 9097 --api-port 8092 --metrics-port 9098 --data-dir ./data/peer2 --mode validator --bootstrap localhost:9095 --genesis $genesis > logs/peer2.log 2>&1 &"
Start-Sleep -Milliseconds 1000

# Launch Peer 3
Write-Host "▶ Launching Peer 3..." -ForegroundColor Green
Write-Host "   Port: 9099 │ API: 8093 │ Metrics: 9100 │ Bootstrap: localhost:9095"
wsl bash -c "cd '$WSL_PATH' && nohup ./analog_codec_v42_hybrid --node-id 3 --name 'Local-Peer-3' --port 9099 --api-port 8093 --metrics-port 9100 --data-dir ./data/peer3 --mode validator --bootstrap localhost:9095 --genesis $genesis > logs/peer3.log 2>&1 &"
Start-Sleep -Milliseconds 1000

# Launch Peer 4
Write-Host "▶ Launching Peer 4..." -ForegroundColor Green
Write-Host "   Port: 9101 │ API: 8094 │ Metrics: 9102 │ Bootstrap: localhost:9095"
wsl bash -c "cd '$WSL_PATH' && nohup ./analog_codec_v42_hybrid --node-id 4 --name 'Local-Peer-4' --port 9101 --api-port 8094 --metrics-port 9102 --data-dir ./data/peer4 --mode validator --bootstrap localhost:9095 --genesis $genesis > logs/peer4.log 2>&1 &"
Start-Sleep -Milliseconds 1000

# Launch Peer 5 (Archive)
Write-Host "▶ Launching Peer 5 (Archive)..." -ForegroundColor Green
Write-Host "   Port: 9103 │ API: 8095 │ Metrics: 9104 │ Bootstrap: localhost:9095"
wsl bash -c "cd '$WSL_PATH' && nohup ./analog_codec_v42_hybrid --node-id 5 --name 'Local-Peer-5' --port 9103 --api-port 8095 --metrics-port 9104 --data-dir ./data/peer5 --mode archive --bootstrap localhost:9095 --genesis $genesis > logs/peer5.log 2>&1 &"

Write-Host ""
Write-Host "╔═══════════════════════════════════════════════════╗" -ForegroundColor Cyan
Write-Host "║            All 5 Peers Launched!                 ║" -ForegroundColor Cyan
Write-Host "╚═══════════════════════════════════════════════════╝" -ForegroundColor Cyan
Write-Host ""

Write-Host "Waiting for peers to initialize (5 seconds)..." -ForegroundColor Yellow
Start-Sleep -Seconds 5

# Check peer health
Write-Host "Checking peer health..." -ForegroundColor Blue
Write-Host ""

$peerProcesses = wsl bash -c "cd '$WSL_PATH' && ps aux | grep analog_codec_v42_hybrid | grep -v grep | wc -l"
Write-Host "Running peer processes: $peerProcesses" -ForegroundColor $(if ($peerProcesses -ge 5) { "Green" } else { "Yellow" })

Write-Host ""
Write-Host "═══════════════════════════════════════════════════" -ForegroundColor Cyan
Write-Host "  Consensus Network Information" -ForegroundColor Cyan
Write-Host "═══════════════════════════════════════════════════" -ForegroundColor Cyan
Write-Host ""
Write-Host "  Network:       analog-local-testnet" -ForegroundColor White
Write-Host "  Genesis:       0x6b3a8e7f...3a9b6e" -ForegroundColor White
Write-Host "  Validators:    4 (Peers 1-4)" -ForegroundColor White
Write-Host "  Archive:       1 (Peer 5)" -ForegroundColor White
Write-Host "  Quorum:        67% (3/4 validators)" -ForegroundColor White
Write-Host "  Byzantine:     Tolerates 1 fault" -ForegroundColor White
Write-Host "  Target Hz:     476,440 Hz" -ForegroundColor White
Write-Host "  GMP Precision: 256 bits" -ForegroundColor White
Write-Host ""
Write-Host "═══════════════════════════════════════════════════" -ForegroundColor Cyan
Write-Host "  Monitoring Commands" -ForegroundColor Cyan
Write-Host "═══════════════════════════════════════════════════" -ForegroundColor Cyan
Write-Host ""
Write-Host "  View Peer 1 logs:" -ForegroundColor Yellow
Write-Host "    wsl bash -c `"cd '$WSL_PATH' && tail -f logs/peer1.log`""
Write-Host ""
Write-Host "  Check peer status:" -ForegroundColor Yellow
Write-Host "    wsl bash -c `"cd '$WSL_PATH' && ./check_peers.sh`""
Write-Host ""
Write-Host "  Stop all peers:" -ForegroundColor Yellow
Write-Host "    wsl bash -c `"cd '$WSL_PATH' && ./stop_peers.sh`""
Write-Host ""
Write-Host "  View consensus metrics:" -ForegroundColor Yellow
Write-Host "    curl http://localhost:9096/metrics  # Peer 1"
Write-Host "    curl http://localhost:9098/metrics  # Peer 2"
Write-Host ""
Write-Host "═══════════════════════════════════════════════════" -ForegroundColor Cyan
Write-Host ""
Write-Host "5-Peer testnet is now running!" -ForegroundColor Green
Write-Host ""
