import numpy as np
import matplotlib.pyplot as plt

# Minimal sample data: redshift, distance modulus, error
z_pantheon = np.array([0.01, 0.05, 0.1, 0.2, 0.3, 0.4, 0.6, 0.8, 1.0, 1.2])
mu_pantheon = np.array([33.5, 35.8, 37.3, 39.2, 40.3, 41.1, 42.0, 42.8, 43.4, 43.9])
mu_err = np.array([0.3]*10)

# Dummy model curve (replace with your model!)
z_model = np.linspace(0.01, 1.5, 100)
mu_model = 5 * np.log10((1 + z_model) * z_model * 3000) + 25

plt.errorbar(z_pantheon, mu_pantheon, yerr=mu_err, fmt='o', label='Sample SNe data')
plt.plot(z_model, mu_model, label='Your model prediction', color='red')
plt.xlabel('Redshift z')
plt.ylabel('Distance Modulus μ')
plt.legend()
plt.grid(True)
plt.show()
