import numpy as np
import matplotlib.pyplot as plt

# Path to your downloaded light curve parameter file
filename = 'hlsp_ps1cosmo_panstarrs_gpc1_all_model_v1_lcparam-full.txt'

# Load data using genfromtxt, skip the '#' in header line, specify delimiter
lc_data = np.genfromtxt(
    filename,
    delimiter=' ',            # space-separated columns
    names=True,               # read header names
    comments='#',             # skip '#' for header lines
    dtype=None,
    encoding=None
)

# Now print field names to confirm
print(lc_data.dtype.names)

# Use zcmb as redshift (CMB frame)
z = lc_data['zcmb']

# Use mb as apparent magnitude, dmb as error
mb = lc_data['mb']
dmb = lc_data['dmb']

# You’ll need absolute magnitude M to get distance modulus:
# mu = mb - M
M = -19.3  # Typical SN Ia absolute magnitude, adjust as needed
mu = mb - M

# Plot data with error bars
plt.errorbar(z, mu, yerr=dmb, fmt='.', alpha=0.5, label='Pan-STARRS1 SNe')

plt.xlabel('Redshift (z)')
plt.ylabel('Distance Modulus (μ)')
plt.title('Pan-STARRS1 Supernova Data')
plt.legend()
plt.grid(True)
plt.show()
