@echo off
REM save_index_html.bat
REM Creates index.html in templates folder for HDGL web interface

if not exist templates mkdir templates

echo Creating templates\index.html...

(
echo ^<!DOCTYPE html^>
echo ^<html lang="en"^>
echo ^<head^>
echo     ^<meta charset="UTF-8"^>
echo     ^<meta name="viewport" content="width=device-width, initial-scale=1.0"^>
echo     ^<title^>HDGL Streaming Node^</title^>
echo     ^<style^>
echo         * { margin: 0; padding: 0; box-sizing: border-box; }
echo         body { font-family: 'Courier New', monospace; background: #000; color: #0f0; overflow: hidden; }
echo         #container { display: flex; flex-direction: column; height: 100vh; }
echo         #header { padding: 10px 20px; background: #111; border-bottom: 2px solid #0f0; display: flex; justify-content: space-between; align-items: center; }
echo         #title { font-size: 24px; font-weight: bold; text-shadow: 0 0 10px #0f0; }
echo         #status { display: flex; gap: 20px; font-size: 12px; }
echo         .status-item { padding: 5px 10px; background: #222; border: 1px solid #0f0; border-radius: 3px; }
echo         #main { display: flex; flex: 1; overflow: hidden; }
echo         #canvas-container { flex: 1; position: relative; background: #000; }
echo         #lattice-canvas { width: 100%%; height: 100%%; image-rendering: pixelated; }
echo         #video-overlay { position: absolute; top: 10px; right: 10px; width: 320px; height: 180px; border: 2px solid #0f0; background: #000; display: none; }
echo         #sidebar { width: 300px; background: #111; border-left: 2px solid #0f0; padding: 20px; overflow-y: auto; }
echo         .control-group { margin-bottom: 20px; padding-bottom: 20px; border-bottom: 1px solid #333; }
echo         .control-label { font-size: 14px; margin-bottom: 10px; color: #0f0; text-transform: uppercase; }
echo         .control { width: 100%%; padding: 8px; background: #000; border: 1px solid #0f0; color: #0f0; font-family: 'Courier New', monospace; margin-bottom: 10px; }
echo         button { width: 100%%; padding: 10px; background: #000; border: 2px solid #0f0; color: #0f0; cursor: pointer; font-family: 'Courier New', monospace; font-size: 14px; transition: all 0.3s; }
echo         button:hover { background: #0f0; color: #000; box-shadow: 0 0 20px #0f0; }
echo         #channel-info { background: #000; padding: 10px; border: 1px solid #0f0; font-size: 11px; line-height: 1.6; max-height: 200px; overflow-y: auto; }
echo         .info-line { margin: 5px 0; }
echo         .info-key { color: #0a0; }
echo         .info-value { color: #0f0; }
echo         #console { background: #000; border: 1px solid #0f0; padding: 10px; height: 150px; overflow-y: auto; font-size: 10px; line-height: 1.4; }
echo         .log-entry { margin: 2px 0; opacity: 0.8; }
echo         .log-info { color: #0f0; }
echo         .log-warn { color: #ff0; }
echo         .log-error { color: #f00; }
echo         input[type="range"] { width: 100%%; height: 4px; background: #333; outline: none; -webkit-appearance: none; }
echo         input[type="range"]::-webkit-slider-thumb { -webkit-appearance: none; width: 15px; height: 15px; background: #0f0; cursor: pointer; border-radius: 50%%; }
echo     ^</style^>
echo ^</head^>
echo ^<body^>
echo     ^<div id="container"^>
echo         ^<div id="header"^>
echo             ^<div id="title"^>🌌 HDGL STREAMING NODE^</div^>
echo             ^<div id="status"^>
echo                 ^<div class="status-item"^>CH: ^<span id="current-channel"^>0^</span^>^</div^>
echo                 ^<div class="status-item"^>FPS: ^<span id="fps"^>0^</span^>^</div^>
echo                 ^<div class="status-item"^>STATUS: ^<span id="connection-status"^>CONNECTING^</span^>^</div^>
echo             ^</div^>
echo         ^</div^>
echo         ^<div id="main"^>
echo             ^<div id="canvas-container"^>
echo                 ^<canvas id="lattice-canvas"^>^</canvas^>
echo                 ^<video id="video-overlay" autoplay loop muted^>^</video^>
echo             ^</div^>
echo             ^<div id="sidebar"^>
echo                 ^<div class="control-group"^>
echo                     ^<div class="control-label"^>Channel Control^</div^>
echo                     ^<input type="number" id="channel-input" class="control" value="0" min="0" max="131071"^>
echo                     ^<button onclick="loadChannel()"^>LOAD CHANNEL^</button^>
echo                     ^<button onclick="nextChannel()"^>NEXT CHANNEL^</button^>
echo                     ^<button onclick="prevChannel()"^>PREV CHANNEL^</button^>
echo                     ^<button onclick="toggleAutoScroll()"^>^<span id="auto-scroll-text"^>AUTO-SCROLL: OFF^</span^>^</button^>
echo                 ^</div^>
echo                 ^<div class="control-group"^>
echo                     ^<div class="control-label"^>Visualization^</div^>
echo                     ^<label^>Brightness: ^<span id="brightness-value"^>100^</span^>%%^</label^>
echo                     ^<input type="range" id="brightness" min="0" max="200" value="100"^>
echo                     ^<label^>Contrast: ^<span id="contrast-value"^>100^</span^>%%^</label^>
echo                     ^<input type="range" id="contrast" min="0" max="200" value="100"^>
echo                 ^</div^>
echo                 ^<div class="control-group"^>
echo                     ^<div class="control-label"^>Channel Info^</div^>
echo                     ^<div id="channel-info"^>^<div class="info-line"^>Waiting for channel data...^</div^>^</div^>
echo                 ^</div^>
echo                 ^<div class="control-group"^>
echo                     ^<div class="control-label"^>Console^</div^>
echo                     ^<div id="console"^>^</div^>
echo                 ^</div^>
echo             ^</div^>
echo         ^</div^>
echo     ^</div^>
echo     ^<script^>
echo         const API_BASE = '/api';
echo         const MEDIA_BASE = '/media';
echo         let currentChannel = 0, autoScroll = false, canvas, ctx, latticeData = null, frameCount = 0, lastFrameTime = Date.now();
echo         window.onload = () =^> {
echo             canvas = document.getElementById('lattice-canvas'^); ctx = canvas.getContext('2d'^);
echo             resizeCanvas(^); window.addEventListener('resize', resizeCanvas^);
echo             log('Initializing HDGL client...', 'info'^); checkStatus(^); loadChannel(^); startRenderLoop(^);
echo             document.getElementById('brightness'^).oninput = e =^> document.getElementById('brightness-value'^).textContent = e.target.value;
echo             document.getElementById('contrast'^).oninput = e =^> document.getElementById('contrast-value'^).textContent = e.target.value;
echo         };
echo         function resizeCanvas(^) { const c = document.getElementById('canvas-container'^); canvas.width = c.clientWidth; canvas.height = c.clientHeight; }
echo         async function checkStatus(^) {
echo             try { const r = await fetch(`${API_BASE}/status`^); const d = await r.json(^);
echo                 document.getElementById('connection-status'^).textContent = 'CONNECTED';
echo                 log(`Connected: ${d.channels} channels`, 'info'^);
echo             } catch { document.getElementById('connection-status'^).textContent = 'ERROR'; log('Connection failed', 'error'^); }
echo         }
echo         async function loadChannel(^) {
echo             const ch = parseInt(document.getElementById('channel-input'^).value^);
echo             if (ch ^< 0 ^|^| ch ^> 131071^) { log('Invalid channel', 'warn'^); return; }
echo             currentChannel = ch; document.getElementById('current-channel'^).textContent = ch;
echo             log(`Loading channel ${ch}...`, 'info'^);
echo             try { const r = await fetch(`${API_BASE}/channel/${ch}`^);
echo                 if (!r.ok^) throw new Error('Channel not found'^); latticeData = await r.json(^);
echo                 updateChannelInfo(latticeData^); if (latticeData.media ^&^& latticeData.media.path^) loadMedia(latticeData.media.path^);
echo                 log(`Channel ${ch} loaded`, 'info'^);
echo             } catch(e^) { log(`Load failed: ${e.message}`, 'error'^); }
echo         }
echo         function loadMedia(p^) {
echo             const v = document.getElementById('video-overlay'^), u = `${MEDIA_BASE}/${p}`;
echo             if (p.match(/\.(mp4^|avi^|mpeg^|mkv^)$/i^)^) { v.src = u; v.style.display = 'block'; v.play(^).catch(e =^> log(`Video error: ${e}`, 'warn'^)^); }
echo             else v.style.display = 'none';
echo         }
echo         function updateChannelInfo(d^) {
echo             document.getElementById('channel-info'^).innerHTML = `
echo                 ^<div class="info-line"^>^<span class="info-key"^>Channel:^</span^> ^<span class="info-value"^>${d.channel}^</span^>^</div^>
echo                 ^<div class="info-line"^>^<span class="info-key"^>Media:^</span^> ^<span class="info-value"^>${d.media ? d.media.name : 'None'}^</span^>^</div^>
echo                 ^<div class="info-line"^>^<span class="info-key"^>Status:^</span^> ^<span class="info-value"^>${d.status ^|^| 'exported'}^</span^>^</div^>`;
echo         }
echo         function nextChannel(^) { currentChannel = (currentChannel + 1^) %% 131072; document.getElementById('channel-input'^).value = currentChannel; loadChannel(^); }
echo         function prevChannel(^) { currentChannel = (currentChannel - 1 + 131072^) %% 131072; document.getElementById('channel-input'^).value = currentChannel; loadChannel(^); }
echo         function toggleAutoScroll(^) { autoScroll = !autoScroll; document.getElementById('auto-scroll-text'^).textContent = `AUTO-SCROLL: ${autoScroll ? 'ON' : 'OFF'}`; }
echo         function startRenderLoop(^) { function r(^) { renderLattice(^); updateFPS(^); requestAnimationFrame(r^); } r(^); }
echo         function renderLattice(^) {
echo             const b = parseInt(document.getElementById('brightness'^).value^) / 100, c = parseInt(document.getElementById('contrast'^).value^) / 100, t = Date.now(^) / 1000;
echo             ctx.fillStyle = '#000'; ctx.fillRect(0, 0, canvas.width, canvas.height^);
echo             if (!latticeData^) return; const gs = 20, cw = canvas.width / gs, ch = canvas.height / gs;
echo             for (let x = 0; x ^< gs; x++^) for (let y = 0; y ^< gs; y++^) {
echo                 const h = ((x * 374761393^) + (y * 668265263^) + currentChannel^) %% 255, w = Math.sin(t + x * 0.5 + y * 0.5^) * 0.5 + 0.5, i = (h / 255^) * w * b * c;
echo                 ctx.fillStyle = `rgb(0, ${Math.floor(i * 255^)}, 0^)`; ctx.fillRect(x * cw, y * ch, cw, ch^);
echo             }
echo             ctx.fillStyle = 'rgba(0, 255, 0, 0.1'^); ctx.fillRect(10, 10, 200, 40^); ctx.fillStyle = '#0f0'; ctx.font = '20px Courier New'; ctx.fillText(`CH ${currentChannel}`, 20, 35^);
echo         }
echo         function updateFPS(^) { frameCount++; const n = Date.now(^); if (n - lastFrameTime ^>= 1000^) { document.getElementById('fps'^).textContent = frameCount; frameCount = 0; lastFrameTime = n; } }
echo         function log(m, t = 'info'^) { const c = document.getElementById('console'^), e = document.createElement('div'^); e.className = `log-entry log-${t}`; e.textContent = `[${new Date(^).toLocaleTimeString(^)}] ${m}`; c.appendChild(e^); c.scrollTop = c.scrollHeight; while (c.children.length ^> 50^) c.removeChild(c.firstChild^); }
echo     ^</script^>
echo ^</body^>
echo ^</html^>
) > templates\index.html

echo.
echo ✓ Created templates\index.html
echo.
echo You can now run: run_server.bat
pause